using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Engines.Craft;
using Server.Network;
using Server.Prompts;
using Server.Targeting;

namespace Server.Items
{
	public enum WandOfEvolutionEffect
	{
		None, //0
      NoManaCost, //1
		DoubleSpellDamage, //2
		EnergyVortex, //3
		MovingCast, //4
	}
	
   public class WandOfEvolution : Spellbook
	{
      private int mEvolutionPoints;
      private WandOfEvolutionEffect m_WandEffect;
		private int m_Bonus;
		private DateTime m_NextSpecial;

		public virtual TimeSpan GetUseDelay{ get{ return TimeSpan.FromSeconds( 4.0 ); } }

		[CommandProperty( AccessLevel.GameMaster )]
		public WandOfEvolutionEffect Effect
		{
			get{ return m_WandEffect; }
			set{ m_WandEffect = value; InvalidateProperties(); }
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public int Bonus
		{
			get{ return m_Bonus; }
			set{ m_Bonus = value; InvalidateProperties(); }
		}

      [CommandProperty(AccessLevel.GameMaster)]
      public int EvolutionPoints
      {
         get { return mEvolutionPoints; }
         set
         {
            mEvolutionPoints = value;
            
            if ( mEvolutionPoints >= 500000 )
               Reveal();
               
             InvalidateProperties();
         }
      }
      
		public DateTime NextSpecial { get { return m_NextSpecial; } set { m_NextSpecial = value; } }
		
      [Constructable]
		public WandOfEvolution() : base()
		{
			Name = "<basefont color=#33FF33>Wand of Evolution";
         
         ItemID = Utility.RandomList( 0xDF2, 0xDF3, 0xDF4, 0xDF5 );
			Content = ulong.MaxValue;
			Hue = 1080;
			Effect = WandOfEvolutionEffect.None;
		}
		
		public void Reveal()
		{
         m_WandEffect = ( WandOfEvolutionEffect ) Utility.RandomMinMax( 1, 2 );
         
         if ( m_WandEffect != WandOfEvolutionEffect.None )
            m_Bonus = Utility.RandomMinMax( 3, 10 );
            
         if ( m_WandEffect == WandOfEvolutionEffect.EnergyVortex )
            m_Bonus = 100; //Utility.RandomMinMax( 50, 100 );
         else if ( m_WandEffect == WandOfEvolutionEffect.MovingCast )
            m_Bonus = Utility.RandomMinMax( 20, 30 );;
         
			SkillBonuses.SetValues( 0, SkillName.Magery, Utility.RandomList( 15, 20, 25, 30 ) );
			SkillBonuses.SetValues( 1, Utility.RandomBool() ? SkillName.Meditation : SkillName.Spellweaving, Utility.RandomList( 10, 15, 20, 25, 30 ) );
         SkillBonuses.SetValues( 2, Utility.RandomBool() ? SkillName.EvalInt : SkillName.Necromancy, Utility.RandomList( 10, 15, 20, 25, 30 ) );
         
			Attributes.SpellDamage = Utility.RandomMinMax( 40, 80 );
			Attributes.DefendChance = 30;
			Attributes.Luck = Utility.RandomMinMax( 100, 300 );
			Attributes.BonusInt = Utility.RandomMinMax( 20, 40 );
			Attributes.EnhancePotions = Utility.RandomMinMax( 20, 35 );
			Attributes.LowerManaCost = 10;
			Attributes.LowerRegCost = Utility.RandomMinMax( 10, 50 );
			Attributes.RegenMana = Utility.RandomMinMax( 4, 8 );
			Attributes.BonusMana = Utility.RandomMinMax( 15, 30 );
			Attributes.BonusHits = Utility.RandomMinMax( 5, 15 );
			Attributes.CastSpeed = 2;
			Attributes.CastRecovery = Utility.RandomMinMax( 2, 5 );
			Slayer = (SlayerName) Utility.RandomList( (int) SlayerName.SpidersDeath, (int) SlayerName.OrcSlaying, (int) SlayerName.OgreTrashing, (int) SlayerName.DragonSlaying, (int) SlayerName.Terathan, (int) SlayerName.SnakesBane );
      }
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
    		string[] EffectName = new string[]
    		{
    			"none", // 0
    			"spell cost no mana chance", // 1
    			"double spell damage chance", // 2
    			"energy vortex on disturb", // 3
    			"casting while moving" // 4
    		};
    		
			string txt = String.Format( "<basefont color=#33FF33>Evolution: {0}/500000\ncasting while moving", mEvolutionPoints );
			
         if ( m_WandEffect == WandOfEvolutionEffect.MovingCast && m_Bonus > 0 )
            txt = txt + String.Format( "\n{0} for {1} sec", EffectName[ (int) m_WandEffect ], m_Bonus );
         else if ( m_WandEffect != WandOfEvolutionEffect.None && m_Bonus > 0 )
            txt = txt + String.Format( "\n{0}: {1}%", EffectName[ (int) m_WandEffect ], m_Bonus );
            
			list.Add( "{0}<basefont color=White>", txt );
		}
		
/*
          private static Hashtable m_Table = new Hashtable();
      
      public bool MoveCasting( Mobile from )
      {
         if ( from == null || m_NextSpecial > DateTime.Now )
            return false;
            
         if ( m_Table[from] != null )
            return true;
            
         ExpireTimer t = new ExpireTimer( from, this, TimeSpan.FromSeconds( m_Bonus ) );
         t.Start();    
         m_Table[from] = t;
         
			from.FixedParticles( 0x375A, 10, 15, 5010, EffectLayer.Waist );
			from.PlaySound( 0x28E );
			from.LocalOverheadMessage( MessageType.Emote, 309, true, "* Casting while moving active *" );
			
			return true;
      }
            
      private class ExpireTimer : Timer
      {
          private Mobile m_Mobile;
          private WandOfEvolution m_Wand;

          public ExpireTimer( Mobile m, WandOfEvolution wand, TimeSpan delay ) : base( delay )
          {
              m_Mobile = m;
              m_Wand = wand;
              Priority = TimerPriority.OneSecond;
          }

          protected override void OnTick()
          {
              Stop();

              m_Mobile.PlaySound( 0x5C2 );
              m_Table.Remove( m_Mobile );
              m_Mobile.SendMessage( 309, "Casting while moving faded." );
              m_Wand.NextSpecial = DateTime.Now + TimeSpan.FromSeconds( 60.0 );
          }
      }
*/
		
		public override bool DisplayLootType{ get{ return false; } }
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( Deleted || mEvolutionPoints >= 500000 || Parent != from )
				return;

			from.SendMessage( "Zamer evolution dusty..." );
			from.Target = new WandOfEvolutionTarget( this );
		}

		public WandOfEvolution( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version

			writer.Write( (int) m_WandEffect );
			writer.Write( (int) m_Bonus );
         writer.Write( (int) mEvolutionPoints );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			m_WandEffect = (WandOfEvolutionEffect)reader.ReadInt();
			m_Bonus = (int)reader.ReadInt();
			mEvolutionPoints = (int)reader.ReadInt();
         
         if ( version == 0 && m_WandEffect == WandOfEvolutionEffect.MovingCast )
         {
            m_Bonus = Utility.RandomMinMax( 6, 10 );
            m_WandEffect = WandOfEvolutionEffect.DoubleSpellDamage;
         }
		}
		
		private class WandOfEvolutionTarget : Target
		{
			private WandOfEvolution m_Wand;

			public WandOfEvolutionTarget( WandOfEvolution wand ) : base( 1, false, TargetFlags.None )
			{
				m_Wand = wand;
			}

			protected override void OnTarget( Mobile from, object target )
			{
			   if ( from == null || m_Wand == null || m_Wand.Deleted || m_Wand.EvolutionPoints >= 500000 || m_Wand.Parent != from || target is StaticTarget || target is LandTarget )
			      return;
            
            if ( !( target is Xanthos.Evo.BaseEvoDust ) )
				{
					from.SendMessage( "Musis zamerit evolution dusty!" );
					return;
				}
				
				Xanthos.Evo.BaseEvoDust dust = (Xanthos.Evo.BaseEvoDust) target;
					
				if ( dust == null )
					from.SendMessage( "Neocekavana chyba (ERROR 01)!" );
				else if( !dust.IsChildOf( from.Backpack ) )
					from.SendMessage( "Musis mit dusty u sebe" );
				else
				{
					int need = ( dust.Amount > 500000 - m_Wand.EvolutionPoints ) ? 500000 - m_Wand.EvolutionPoints : dust.Amount;
					
               m_Wand.EvolutionPoints += need;
               dust.Consume( need );
               from.PlaySound( 501 );
               from.FixedParticles( 14120, 1, 10, 0x1F78, dust.Hue, 5, EffectLayer.Waist );
					from.SendMessage("Magicka hulka absorbovala {0} dustu.", need );
               
               if ( m_Wand.EvolutionPoints >= 500000 )
               {
                  from.PlaySound( 533 );
                  m_Wand.BlessedFor = from;
                  from.SendMessage( 77, "Hulka dosahla maximalni urovne a jeji skryte vlastnosti byly odhaleny!" );
//                   m_Wand.Reveal();
               }
				}
			}
		}
	}
}

